<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;

class ExportTableData extends Command
{
    // run: php artisan export:data
    protected $signature = 'export:data';
    protected $description = 'Export data from tables to a JSON file';

    public function handle()
    {
        // ذخیره در یک آرایه
        $data = [
            'routes' => DB::table('routes')->get(),
            'permissions' => DB::table('permissions')->get(),
            'permission_route' => DB::table('permission_route')->get(),
            'permission_user' => DB::table('permission_user')->get(),
            'permission_role' => DB::table('permission_role')->get(),
            'roles' => DB::table('roles')->get(),
            'role_user' => DB::table('role_user')->get(),
            'role_route' => DB::table('role_route')->get(),
        ];

        // تبدیل به JSON و ذخیره در فایل
        // File::put(storage_path('exports/data.json'), json_encode($data, JSON_PRETTY_PRINT));
        // تبدیل آرایه به JSON
        $jsonData = json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);

        // ذخیره در فایل
        file_put_contents(base_path('database/backup/tablesExport(routes-permissions).json'), $jsonData);

        $this->info('Data exported successfully!');
    }
}