<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class GetTableColumns extends Command
{
    protected $signature = 'get:columns';
    protected $description = 'Extract all table columns for translation';

    public function handle()
    {
        // گرفتن نام دیتابیس از تنظیمات
        $database = env('DB_DATABASE');
        // گرفتن لیست جداول از PostgreSQL
        $tables = DB::select("SELECT table_name FROM information_schema.tables WHERE table_schema = 'public' AND table_type = 'BASE TABLE'");
        $attributes = [];

        foreach ($tables as $table) {
            $tableName = $table->table_name;
            // گرفتن ستون‌های هر جدول
            $columns = Schema::getColumnListing($tableName);

            foreach ($columns as $column) {
                // اضافه کردن ستون به لیست attributes
                $attributes[$column] = $column; // مقدار پیش‌فرض همون نام ستونه
            }
        }

        // خروجی به صورت آرایه PHP
        $output = '<?php' . PHP_EOL . PHP_EOL . 'return ' . var_export(['attributes' => $attributes], true) . ';';

        // ذخیره توی فایل
        file_put_contents(base_path('resources/lang/fa/columns.php'), $output);

        $this->info('ستون‌ها با موفقیت استخراج و در فایل columns.php ذخیره شدند.');
    }
}