<?php

namespace App\Http\Controllers\API\CronJob;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Log;
use App\Models\TimeSlot;
use App\Models\Message;
use App\Models\DefaultMessage;
use Carbon\Carbon;
use App\Services\SmsIrService;
use Morilog\Jalali\Jalalian;

class CronJobController extends Controller
{
    //
    protected $smsService;

    public function __construct(SmsIrService $smsService)
    {
        $this->smsService = $smsService;
    }

    public function usersVisitToday() {
        $now = Carbon::now();
        $currentTime = $now->toTimeString(); // زمان فعلی (مثلاً '14:30:00')
        $today = $now->toDateString();       // تاریخ امروز (مثلاً '2025-04-24')
        $tomorrow = $now->addDay()->toDateString(); // تاریخ فردا
        
        $timeSlots = TimeSlot::with(['user','patient'])
            ->whereBetween('date_at', [$today, $today])
            ->whereNotNull('user_id')
            ->where(function($query) use ($today, $currentTime) {
                // اگر تاریخ امروز است، زمان شروع باید بیشتر از الان باشد
                $query->where('date_at', '>', $today)
                    ->orWhere(function($query) use ($today, $currentTime) {
                        $query->where('date_at', $today)
                            ->where('start_time', '>', $currentTime)
                            ;
                    });
            })
            ->orderBy('date_at')
            ->orderBy('start_time')
            ->get();
            $numbers = [];
            $messages = [];
        
        
        $edfaultMessage = DefaultMessage::find(1);
        foreach ($timeSlots as $reservation) {
            if ($reservation->reservation_phone && $reservation->reservation_name && $reservation->patient) {
                $numbers[] = $reservation->reservation_phone ?? $reservation->patient->user->phone;
                
                $messages[] = $message = str_replace(
                    ['{name}', '{date}', '{time}'],
                    [
                        $reservation->reservation_name ?? $reservation->patient->user->name ?? $reservation->patient->fullname,
                        Jalalian::fromCarbon($reservation->date_at)->format('dم F'),
                        Carbon::parse($reservation->start_time)->format('H:i')
                    ],
                    $edfaultMessage->body
                );
                
                if($reservation->patient->user->id){
                    $message = Message::create([
                        'user_id' => $reservation->patient->user->id,
                        'body' => $message,
                        'status' => 'sent'
                    ]);
                }
            }
            
            // یا می‌توانید ایمیل/نوتیفیکیشن ارسال کنید
            // Notification::send($reservation->user, new UpcomingReservationNotification($reservation));
        }

        // ارسال فوری
        $result = $this->smsService->sendLikeToLike($numbers, $messages);

        // ارسال زمان‌بندی شده (تایمستاپ یونیکس)
        // $sendTime = strtotime('2025-04-25 14:00:00');
        // $result = $this->smsService->sendLikeToLike($numbers, $messages, $sendTime);

        // if ($result['success']) {
        //     echo "پیامک‌ها با موفقیت ارسال شدند. شناسه بسته: " . $result['data']['packId'];
        // } else {
        //     echo "خطا: " . $result['error'];
        // }
        
        return [$timeSlots->count(), $numbers, $messages];
    }
}
