<?php

namespace App\Http\Controllers\API\v1;

use App\Http\Controllers\API\BaseController;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Services\ModelStatsService;
use App\Models\User;
use App\Models\Patient;
use App\Models\TimeSlot;
use Morilog\Jalali\Jalalian;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;


class DashboardController extends BaseController
{
    protected $ModelStatsService;

    public function __construct(ModelStatsService $ModelStatsService)
    {
        $this->ModelStatsService = $ModelStatsService;
    }

    public function index(){

        $success['user_stats'] = $this->ModelStatsService->getStats(\App\Models\User::class, 'monthly');
        $success['patient_stats'] = $this->ModelStatsService->getStats(\App\Models\Patient::class, 'monthly');
        $success['treatment_stats'] = $this->ModelStatsService->getStats(\App\Models\Treatment::class, 'weekly');
        $success['timeSlot_stats'] = $this->ModelStatsService->getStats(\App\Models\TimeSlot::class, 'daily',[
            ['user_id', '!=', null],
            // ['status', 'in', ['active', 'pending']],
            // ['created_at', 'between', ['2024-01-01', '2024-12-31']],
            // ['title', 'like', '%صبح%'],
        ]);

        $success['timeSlots'] = $this->ModelStatsService->getModelWithRelations(\App\Models\TimeSlot::class, 12, [
            ['user_id', '!=', null],
            // ['status', 'in', ['active', 'pending']],
            // ['created_at', 'between', ['2024-01-01', '2024-12-31']],
            // ['title', 'like', '%صبح%'],
        ]);
        

        
        $success['title'] = 'نمایش اطلاعات';
        $success['message'] = 'اطلاعات ساخته شد';
        
        return $this->sendResponse($success, $success['message']);

        return response()->json([
            $user_stats
        ]);
    }

    public function getChartData(Request $request)
    {
        $model = $request->get('model'); // مثلا: patients
        $period = $request->get('period', 'monthly'); // daily | weekly | monthly
    
        $table = match ($model) {
            'patients' => 'patients',
            'time_slots' => 'time_slots',
            default => abort(400, 'مدل نامعتبر است')
        };
    
        // گرفتن داده‌ها با مرتب‌سازی
        if($model == 'time_slots'){

            $query = DB::table($table)->whereNotNull('user_id')
                ->select('date_at')
                ->orderBy('date_at')
                ->get();
        }else{

            $query = DB::table($table)->select('created_at')->orderBy('created_at')->get();
        }
    
        // گروه‌بندی براساس بازه زمانی
        $grouped = $query->groupBy(function ($item) use ($period, $model) {
            $date = Jalalian::fromDateTime($model == 'time_slots' ? $item->date_at : $item->created_at);
    
            // تبدیل تاریخ جلالی به میلادی و محاسبه هفته سال
            $carbonDate = Carbon::createFromFormat('Y-m-d H:i:s', $date->toCarbon()->toDateTimeString());
    
            return match ($period) {
                'daily' => $date->format('%Y/%m/%d'), // تاریخ کامل شمسی
                'weekly' => 'هفته ' . $carbonDate->weekOfYear . ' سال ' . $carbonDate->year,
                'monthly' => $date->format('%B %Y'), // مثلاً "فروردین ۱۴۰۳"
                default => $date->format('%Y/%m/%d'),
            };
        });
    
        $labels = $grouped->keys();
        $data = $grouped->map(fn($items) => $items->count())->values();
    
        return response()->json([
            'labels' => $labels->values(),
            'data' => $data,
        ]);
    }

}
