<?php

namespace App\Http\Controllers\API\v1;

use App\Http\Controllers\API\BaseController;
use App\Http\Controllers\Controller;
use App\Models\DefaultMessage;
use Illuminate\Http\Request;

class DefaultMessageController extends BaseController
{
    //
    public function index()
    {
        $success['messages'] =  DefaultMessage::all();
        return $this->sendResponse($success, 'اطلاعات دریافت شد');
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            'title' => 'required|string',
            'body' => 'required|string',
            'variables' => 'nullable|array',
        ]);

        $defaultMessage = DefaultMessage::create($data);

        $success['title'] = 'ذخیره اطلاعات';
        $success['message'] = 'پیام پیش‌فرض ساخته شد';
        $success['defaultMessage'] = $defaultMessage;
        
        return $this->sendResponse($success, $success['message']);
    }

    public function update(Request $request, $id)
    {
        if($id == 1){
            $success['title'] = 'ذخیره اطلاعات';
            $success['message'] = 'پیام ویرایش شد';
            $success['defaultMessage'] = null;
            return $this->sendResponse($success, $success['message']);
        }
        $defaultMessage = DefaultMessage::findOrFail($id);

        $data = $request->validate([
            'title' => 'sometimes|string',
            'body' => 'sometimes|string',
            'variables' => 'nullable|array',
        ]);

        $defaultMessage->update($data);

        
        $success['title'] = 'ذخیره اطلاعات';
        $success['message'] = 'پیام ویرایش شد';
        $success['defaultMessage'] = $defaultMessage;
        
        return $this->sendResponse($success, $success['message']);
    }

    public function destroy($id)
    {
        DefaultMessage::findOrFail($id)->delete();

        return response()->json(['message' => 'پیام پیش‌فرض حذف شد']);
    }
}
