<?php

namespace App\Http\Controllers\API\v1;

use App\Http\Controllers\API\BaseController;


use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Maatwebsite\Excel\Facades\Excel;
use App\Models\User;
use App\Models\Patient;
use Morilog\Jalali\Jalalian;

class ExcelController extends BaseController
{
    public function uploadExcel(Request $request)
    {
        $request->validate([
            'excel_file' => 'required|file|mimes:xlsx,xls,csv'
        ]);

        try {
            $file = $request->file('excel_file');
            
            // خواندن فایل اکسل
            $data = Excel::toArray([], $file);
            
            if (empty($data)) {
                return response()->json([
                    'success' => false,
                    'message' => 'فایل خالی است'
                ], 400);
            }


            // اولین شیت را می‌گیریم
            $rows = $data[0];
            
            /*
            [
                0 "آدرس", address
                1 "موبایل", in users table phone
                2 "تلفن محل کار", work_phone
                3 "تلفن منزل", home_phone
                4 "تاریخ تولد", birth_day_at
                5 "تاهل", marital_status
                6 "جنسیت", sex
                7 "نام و نام خانوادگی", fullname
                8 "شماره پرونده", uuid
                9 "ردیف"
            ]
            */
            // return $rows;
            set_time_limit(300);
            // قبل از حلقه
            $errorLogHeader = "\n| Row | UUID | Phone | Fullname | Error Message |\n".
            "|-----|------|-------|----------|---------------|\n";

            foreach ($rows as $key => $value) {
                # code...
                if($key !== 0){
                    try {
                        $phone = '0098' . ltrim($value[1] ?? $value[9], '0');
                        $user = User::where(['phone' => $phone])->first();
                        if(!$user){
                            $user = User::create([
                                'phone' => $phone,
                                'name' => $value[7],
                                'email' => $phone
                                // 'code_confirm' => $code
                            ]);
                        }
                        $birthDay = null;
                        if (!empty($value[4])) {
                            $birthDay = Jalalian::fromFormat('Y/m/d', $value[4])->toCarbon();
                        }

                        $patient = Patient::create([
                            "uuid" => $value[8],
                            'user_id'=> $user->id,
                            "uuid_string" => $value[8],
                            "address" => $value[0],
                            // "in users table phone" => $value[1],
                            "work_phone" => $value[2],
                            "home_phone" => $value[3],
                            "birth_day_at" => $birthDay,//$value[4],
                            "marital_status" => $value[5],
                            "sex" => $value[6],
                            "fullname" => $value[7],
                        ]);
                    }catch (\Exception $e) {
                        Log::error($e);

                        $lastUuid = Patient::max('uuid');
                        $patient = Patient::create([
                            "uuid" => $lastUuid+10000,
                            'user_id'=> $user->id,
                            "uuid_string" => $value[8],
                            "address" => $value[0],
                            // "in users table phone" => $value[1],
                            "work_phone" => $value[2],
                            "home_phone" => $value[3],
                            "birth_day_at" => $birthDay,//$value[4],
                            "marital_status" => $value[5],
                            "sex" => $value[6],
                            "fullname" => $value[7],
                        ]);
                        
                        // ذخیره خطاها برای گزارش نهایی
                        $failedRows[] = [
                            'row' => $key,
                            'uuid' => $value[8],
                            'phone' => $value[1],
                            'fullname' => $value[7],
                            'error' => str_replace("\n", " ", $e->getMessage()),
                            'raw_data' => $value,
                            'exception' => get_class($e)
                        ];
                    }

                }
            }
            // // نمایش خطاها (اختیاری)
            // در پایان پردازش
            if (!empty($failedRows)) {
                $table = new \Symfony\Component\Console\Helper\Table(new \Symfony\Component\Console\Output\ConsoleOutput());
                $table->setHeaders(['Row', 'UUID', 'Phone', 'Name', 'Error']);
                
                foreach ($failedRows as $error) {
                    $table->addRow([
                        $error['row'],
                        $error['uuid'],
                        $error['phone'],
                        mb_substr($error['fullname'], 0, 15),
                        mb_substr($error['error'], 0, 50)
                    ]);
                }
                
                $table->render();
            }
            
            // حذف هدر اگر وجود دارد
            $headers = array_shift($rows);

            // تبدیل ردیف‌ها به آرایه‌های انجمنی
             $processedData = array_map(function($row) use ($headers) {
                return array_combine($headers, $row);
            }, $rows);

            return response()->json([
                'success' => true,
                'message' => 'فایل با موفقیت پردازش شد',
                'data' => $processedData
            ]);

        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'message' => 'خطا در پردازش فایل: ' . $e->getMessage()
            ], 500);
        }
    }
}