<?php

namespace App\Http\Controllers\API\v1;

use App\Http\Controllers\API\BaseController;
use App\Http\Controllers\Controller;
use App\Models\DefaultMessage;
use Illuminate\Http\Request;
use App\Models\Message;
use App\Models\User;
use App\Services\MessageService;
use App\Services\SmsIrService;
use Illuminate\Support\Facades\Log;

class MessageController extends BaseController
{
    protected $smsService;

    public function __construct(SmsIrService $smsService)
    {
        $this->smsService = $smsService;
    }
    //
    public function index()
    {
        $success['messages'] = $messages = Message::with('user')->orderByDesc('created_at')->get();
        $success['users'] = $users = User::with('patient')->orderByDesc('created_at')->get();
        
        return $this->sendResponse($success, 'اطلاعات دریافت شد');
    }

    public function sendMessage(Request $request) {
        // اعتبارسنجی ورودی‌ها
        $validated = $request->validate([
            // 'users_id' => 'required|exists:users,id',
            
            'users_id' => ['required', 'array'],
            'users_id.*.id' => ['required', 'exists:users,id'],
            'users_id.*.name' => ['sometimes', 'string'],
            'users_id.*.phone' => ['sometimes', 'string'],
            'body' => 'required|string',
            'variables' => 'nullable|array', // دریافت مقدار متغیرها (اختیاری)
        ]);
    
        // مقداردهی پیش‌فرض `{}` در صورت خالی بودن `variables`
        $variables = $validated['variables'] ?? [];
    
        // جایگزینی متغیرها در متن پیام
        $body = $validated['body'];
        foreach ($variables as $key => $value) {
            $body = str_replace("{" . $key . "}", $value, $body);
        }
    
        // حذف متغیرهای جای‌گذاری نشده از متن
        $body = preg_replace('/\{[a-zA-Z0-9_]+\}/', '', $body);
        $messages = [];
        
        
        // // استخراج آرایه‌ای از شماره‌ها
        $phones = collect($request->users_id)->pluck('phone')->all();
        $status = 'pending';
        if($phones){
            $result = $this->smsService->sendBulkSms(
                mobiles: $this->smsService->normalizePhoneNumbers($phones),
                message: $body,
                immediate: true // ارسال فوری
            );
    
            if ($result['success']) {
                // پیامک‌ها با موفقیت ارسال شدند
                $status = 'sent';
            }
        }
        foreach ($request->users_id as $key => $user) {

            // $status = 'pending';
            // $result = $this->smsService->sendSms(
            //     mobile: $user['phone'],//$this->smsService->normalizePhoneNumbers([$user['phone']])[0],
            //     message: $body,
            //     immediate: true // ارسال فوری
            // );

            // if ($result['success']) {
            //     $status = 'sent';
            // }else{
            //     Log::error($result);
            // }
            // ذخیره پیام در دیتابیس
            $message = Message::create([
                'user_id' => $user['id'],
                'body' => $body,
                'status' => $status
            ]);
            $messages[] = $message->load('user');
        }
  

        $success['title'] = 'ذخیره اطلاعات';
        $success['message'] = "پیام با موفقیت ارسال شد";
        $success['messagesRecord'] = $messages;
        
        return $this->sendResponse($success, $success['message']);
    }
    
    public function previewMessage(Request $request) {
        // اعتبارسنجی ورودی‌ها
        $validated = $request->validate([
            'body' => 'required|string',
            'variables' => 'nullable|array', // اگر مقدار `variables` ارسال نشد، مقدار پیش‌فرض `{}` می‌گیرد
        ]);
    
        // دریافت مقدار متغیرها، اگر ارسال نشده باشد مقدار خالی `{}` قرار می‌گیرد
        $variables = $validated['variables'] ?? [];
    
        // جایگزین کردن متغیرها در متن پیام
        $body = $validated['body'];
        foreach ($variables as $key => $value) {
            $body = str_replace("{" . $key . "}", $value, $body);
        }
    
        // بررسی متغیرهایی که مقدار ندارند و حذف آن‌ها
        $body = preg_replace('/\{[a-zA-Z0-9_]+\}/', '', $body);
    
        // ارسال پاسخ JSON
        return response()->json(["preview" => $body]);
    }

    public function destroy($id)
    {
        $message = Message::findOrFail($id);
        $message->delete();

        return response()->json(['message' => 'پیام حذف شد']);
    }
}
