<?php


namespace App\Http\Controllers\Api\v1;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use App\Notifications\SimpleNotification;

class NotificationController extends Controller
{
    public function index(Request $request)
    {
        return response()->json(
            $request->user()->notifications()->paginate(10)
        );
    }

    public function unread(Request $request)
    {
        return response()->json(
            $request->user()->unreadNotifications
        );
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            'user_id' => 'required|exists:users,id',
            'title' => 'required|string',
            'body' => 'required|string',
        ]);

        $user = User::find($data['user_id']);
        $user->notify(new SimpleNotification($data['title'], $data['body']));

        return response()->json(['message' => 'Notification sent']);
    }

    public function markAsRead(Request $request, $id)
    {
        $notification = $request->user()->notifications()->findOrFail($id);
        $notification->markAsRead();

        return response()->json(['message' => 'Marked as read']);
    }

    public function markAllAsRead(Request $request)
    {
        $request->user()->unreadNotifications->markAsRead();

        return response()->json(['message' => 'All marked as read']);
    }

    public function destroy(Request $request, $id)
    {
        $notification = $request->user()->notifications()->findOrFail($id);
        $notification->delete();

        return response()->json(['message' => 'Notification deleted']);
    }

}


/*
عملکرد	روش	آدرس
دریافت همه نوتیفیکیشن‌ها	GET	/api/v1/notifications
دریافت فقط نوتیفیکیشن‌های خوانده‌نشده	GET	/api/v1/notifications/unread
ارسال نوتیفیکیشن جدید	POST	/api/v1/notifications
علامت‌زنی تکی به عنوان خوانده‌شده	POST	/api/v1/notifications/{id}/read
علامت‌زنی همه به عنوان خوانده‌شده	POST	/api/v1/notifications/mark-all-read
حذف یک نوتیفیکیشن	DELETE	/api/v1/notifications/{id}
*/