<?php

namespace App\Http\Controllers\API\v1;

use App\Http\Controllers\API\BaseController;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Role;
use App\Models\Permission;
use App\Models\User;
use App\Models\Route;

class RolePermissionController extends BaseController
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
        $success['roles'] = $roles = Role::with('permissions', 'users', 'routes')->latest('id')->get();
        $success['permissions'] = $permissions = Permission::with('roles', 'users', 'routes')->latest('id')->get();
        $success['users'] = $users = User::take(100)->latest('id')->get();
        $success['routes'] = $routes = Route::orderBy('updated_at', 'desc')->latest('id')->get();
        
        return $this->sendResponse($success, 'اطلاعات دریافت شد');
    }

    public function createUpdatePermission(Request $request) {
        $request->validate([
            'name' => 'required|string|max:255',
        ]);

        // return $request;
        
        $id = $request->input('id');
        $name = $request->input('name');
        $routes = $request->input('routes[]') ?? $request->input('routes');
        $users = $request->input('users[]') ?? $request->input('users');

        // return $routes;

        $permission = Permission::find($id);
        $permissionName = Permission::where('id', '!=', $id)->where('name', $name)->first();
        
        if ($permissionName) {
            return response()->json([
                'errors' => ['name' => 'نام پرمیشن نباید تکراری باشد.'],
            ], 422);
        }
        if(!$permission){
            $permission = new Permission();
        }
        $permission->name = $name;
        $permission->save();
        
        $routesId = $routes;
        if (!empty($routes) && (is_array($routes[0]) || is_object($routes[0]))) {
            $routesId = array_column($routes, 'id');
        }
        $usersId = $users;
        if (!empty($users) && (is_array($users[0]) || is_object($users[0]))) {
            $usersId = array_column($users, 'id');
        }

        $permission->routes()->sync($routes ? $routesId : []);
        $permission->users()->sync($users ? $usersId : []);

        $success['title'] = 'ذخیره اطلاعات';
        $success['message'] = 'ذخیره اطلاعات موفقیت آمیز بود.';
        $success['status'] = 'success';
        $success['permissions'] = $permissions = Permission::with('roles', 'users', 'routes')->latest('id')->get();
        return $this->sendResponse($success, 'اطلاعات ذخیره شد.');
    }

    
    public function createUpdateRole(Request $request) {
        $request->validate([
            'name' => 'required|string|max:255',
        ]);

        $id = $request->input('id');
        $name = $request->input('name');
        $routes = $request->input('routes[]');
        $permissions = $request->input('permissions[]');
        $role = null;
        if (!(empty($id) || !is_numeric($id))) {
            $role = Role::find($id);
            $roleName = Role::where('id', '!=', $id)->where('name', $request->name)->first();
            if ($roleName) {
                return response()->json([
                    'errors' => ['name' => 'نام نقش نباید تکراری باشد.'],
                ], 422);
            }
        }
        
        if(!$role){
            $roleName = Role::where('name', $request->name)->first();
            if ($roleName) {
                return response()->json([
                    'errors' => ['name' => 'نام نقش نباید تکراری باشد.'],
                ], 422);
            }
            $role = new Role();
        }
        $role->name = $request->name;
        $role->save();
        
        $routesId = $routes;
        if (!empty($routes) && (is_array($routes[0]) || is_object($routes[0]))) {
            $routesId = array_column($routes, 'id');
        }
        $permissionsId = $permissions;
        if (!empty($permissions) && (is_array($permissions[0]) || is_object($permissions[0]))) {
            $permissionsId = array_column($permissions, 'id');
        }
        
        $role->routes()->sync($routes ? $routesId : []);
        $role->permissions()->sync($permissions ? $permissionsId : []);

        $success['title'] = 'ذخیره اطلاعات';
        $success['message'] = 'ذخیره اطلاعات موفقیت آمیز بود.';
        $success['status'] = 'success';
        $success['roles'] = $roles = Role::with('permissions', 'users', 'routes')->latest('id')->get();
        return $this->sendResponse($success, 'اطلاعات ذخیره شد.');
    }

    /**
     * get the specified resource from roles.
     */
    public function showRole($id) {
        
        $success['role'] = $role = Role::where('id', $id)->with('permissions', 'users', 'routes')->latest('id')->first();
        if(!$role){
            return $this->sendError('ایتمی وجود ندارد', ['error' => 'ایتمی وجود ندارد']);
        }
        
        return $this->sendResponse($success, 'اطلاعات دریافت شد');
    }

    
    /**
     * Remove the specified resource from storage.
     */
    public function deletePermission(string $id)
    {
        //
        $permission = Permission::where('id', $id)->delete();

        $success['message'] =  'با موفقیت حذف گردید.';
        return $this->sendResponse($success, 'با موفقیت حذف گردید.');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
