<?php

namespace App\Http\Controllers\API\v1;

use App\Http\Controllers\API\BaseController;
use App\Models\Route;
use App\Models\Permission;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Route as RouteMain;
use Morilog\Jalali\Jalalian;
use Carbon\Carbon;

class RouteController extends BaseController
{

    public function updateRoutes()
    {
        $routes = RouteMain::getRoutes()->getRoutes();

        $groupedRoutes = [];
        foreach ($routes as $route) {
            $prefix = $route->getPrefix(); // دریافت پیشوند
            $groupedRoutes[$prefix][] = [
                'uri' => $route->uri(),
                'methods' => json_encode($route->methods()),
                'name' => $route->getName(),
                'action' => $route->getActionName(),
            ];

            $existingRoute = Route::where('path', $route->uri())->first();
            
            if (!$existingRoute) {
                
                $perrmission_ = Permission::updateOrCreate(['name' => $route->getName() ?? $route->uri()],[]);

                $route_ = Route::updateOrCreate(
                    [
                        'path' => $route->uri()
                    ],
                    [
                        'title' => $route->getName() ?? $route->uri(),
                        'route_name' => $route->getName(),
                        'path' => $route->uri(),
                        'methods' => json_encode($route->methods()),
                        'group' => $route->getPrefix(),
                        'type' => 'back-end',
                    ] // داده‌های به‌روزرسانی یا ایجاد
                );
                
                $perrmission_->routes()->attach($route_->id);
            }
        }
        return $groupedRoutes;
    }


    public function updateRoutesFront(Request $request){
        
        // return $routes = $request->routes;

        foreach ($request->routes as $route) {

            $existingRoute = Route::where('path', $route['path'])->first();
            
            if (!$existingRoute) {
                // فقط اگه path تکراری نباشه، رکورد جدید اضافه می‌شه
                
                $perrmission_ = Permission::updateOrCreate(
                    ['name' => $route['folder']."/".$route['file']."=>".$route['path']],
                    ['updated_at' => now()]
                );
                // return $route;
                $route_ = Route::create(
                    [
                        'title' => $route['folder']." ".$route['file'],
                        'route_name' => $route['folder']." ".$route['file'],
                        'path' => $route['path'],
                        'methods' => '["GET"]',
                        'group' => $route['folder'],
                        'type' => $route['type'],
                        'showin' => $route['type'] == "front-end" ? 'menu' : 'api',
                    ] // داده‌های به‌روزرسانی یا ایجاد
                );
                $perrmission_->routes()->attach($route_->id);
            }
        }

        return response()->json([
            'message' => 'Routes processed successfully',
            // 'inserted_count' => $insertedCount,
            'total_received' => count($request->routes),
            'routes' => Route::orderBy('updated_at', 'desc')->get()
        ]);

    }

    /**
     * نمایش همه روت‌ها
     */
    public function index()
    {

        // $user = request()->user();
        // return $user;

        // دریافت همه روت‌ها از دیتابیس
        $routes = Route::orderBy('updated_at', 'desc')->get();
        return response()->json($routes, Response::HTTP_OK);
    }

    /**
     * ذخیره روت جدید در دیتابیس
     */
    public function store(Request $request)
    {
        // اعتبارسنجی داده‌های ورودی
        $request->validate([
            'title' => 'required|string|max:255',
            // 'slug' => 'required|string|max:255',
            'path' => 'required|string|max:255|unique:routes,path',
            'methods' => 'nullable|json',
            // 'text' => 'nullable|string|max:255',
            'type' => 'nullable|string|max:255',
            'divider' => 'nullable',
            'parent_id' => 'nullable|exists:routes,id',
            'description' => 'nullable|string',
            'icon' => 'nullable|string',
            'attributes' => 'nullable|json',
            'actived_at' => 'nullable',
        ]);
        $request->request->remove('id');
        
        
        $request->merge([
            'divider' => $request->has('divider') ? 1 : 0,
        ]);
        
        if (!$request->filled('parent_id')) {
            $request->request->remove('parent_id');
        }
        if ($request->filled('methods')) {
            $request->merge(['methods' => json_encode($request->methods, true)]);

        }else{
            $request->request->remove('methods');
        }
        if ($request->filled('attributes')) {
            $request->merge(['attributes' => json_encode($request->attributes, true)]);
        }else{
            $request->request->remove('attributes');
        }
        if ($request->filled('actived_at')) {
            $request->merge(['actived_at' => now()]); // تاریخ جاری
        } else {
            $request->merge(['actived_at' => null]);
        }
        
        // return $request->all();
        // ایجاد روت جدید
        $route = Route::create($request->all());

        
        if($route && $route->id){
            $viewDashboard = Permission::create(['name' => $request->title]);
            $viewDashboard->routes()->attach($route->id);
        }
        // return response()->json($route, Response::HTTP_CREATED);
        
        $success['route'] =  $route;
        $success['message'] =  'با موفقیت اضافه گردید.';
        return $this->sendResponse($success, 'با موفقیت اضافه گردید.');
    }

    /**
     * نمایش یک روت خاص
     */
    public function show(Route $route)
    {
        return response()->json($route, Response::HTTP_OK);
    }

    /**
     * به‌روزرسانی روت در دیتابیس
     */
    public function update(Request $request, string $id)
    {
        // اعتبارسنجی داده‌های ورودی
        $request->validate([
            'title' => 'required|string|max:255',
            // 'slug' => 'required|string|max:255',
            'path' => 'required|string|max:255|unique:routes,path,' . $id,
            'methods' => 'nullable|json',
            // 'text' => 'nullable|string|max:255',
            'type' => 'nullable|string|max:255',
            'divider' => 'nullable',
            'parent_id' => 'nullable|numeric|exists:routes,id',
            'description' => 'nullable|string',
            'icon' => 'nullable|string',
            'attributes' => 'nullable|json',
            // 'actived_at' => 'nullable|date',
        ]);

        $route = Route::find($id);
        if ($route) {
            $permission = $route->permissions()->first();
            if ($permission) {
                // تغییر نام پرمیشن
                $permission->update([
                    'name' => $request->title
                ]);
            }
        }
        
        // return $request->parent_id ?? 'aaa';

        $route = Route::find($id);
        $route->title = $request->title;
        $route->orderby = $request->orderby;
        $route->path = $request->path;
        $route->methods = $request->methods;
        $route->type = $request->type;
        $route->showin = $request->showin;
        $route->group = $request->group;
        $route->divider = $request->divider;
        $route->parent_id = ($request->parent_id && $request->parent_id != "") ? $request->parent_id : null;
        $route->description = $request->description;
        $route->icon = $request->icon;
        // $route->attributes = $request->attributes ?? null;
        $route->actived_at = $request->actived_at ? Carbon::now() : null;
        $route->save();

        $success['title'] = 'ذخیره اطلاعات';
        $success['message'] = 'ذخیره اطلاعات موفقیت آمیز بود.';
        $success['route'] = $route;
        
        return $this->sendResponse($success, 'با موفقیت ذخیره گردید.');
        return response()->json($route, Response::HTTP_OK);
    }

    /**
     * حذف روت از دیتابیس
     */
    public function destroy(Route $route)
    {
        // حذف روت
        $route->delete();

        $success['message'] =  'با موفقیت حذف گردید.';
        return $this->sendResponse($success, 'با موفقیت حذف گردید.');
        // return response()->json(null, Response::HTTP_NO_CONTENT);
    }
}
