<?php

namespace App\Http\Controllers\API\v1;

use App\Http\Controllers\API\BaseController;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Type;
use App\Services\MainService;

class TypeController extends BaseController
{
    
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
        $tags = request()->tags;
        $modle_name = request()->modle_name;
        $model_id = request()->model_id;
        $success['types'] = Type::where('tags', 'like', "%$tags%")
            // ->when($modle_name, ($auery1) {
            //     $auery1->where('typeable_type', $modle_name);
            // })
            // ->when($model_id, ($auery2) {
            //     $auery2->where('typeable_id', $model_id);
            // })
            ->latest()->get();

        $success['models'] = MainService::models();

        return $this->sendResponse($success, 'اطلاعات دریافت شد');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        // return $request;
        $request->validate([
            'name' => 'required|string|max:255',
            'description' => 'nullable|string',
            'tags' => 'nullable|json',
            'typeable_type' => 'nullable|string|max:255',
            'typeable_id' => 'nullable|numeric',
        ]);

        $type = new Type();
        
        $type->name = $request->name;
        $type->description = $request->description ?? '';
        $type->tags = $request->tags;
        $type->typeable_type = $request->typeable_type;
        $type->typeable_id = $request->typeable_id;
        $type->save();
        
        $success['title'] = 'ذخیره اطلاعات';
        $success['message'] = 'ذخیره اطلاعات موفقیت آمیز بود.';
        $success['type'] = $type;
        
        return $this->sendResponse($success, 'با موفقیت اضافه گردید.');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
        // return $id;
        // return $request;

        $request->validate([
            'id' => 'required|exists:types,id',
            'name' => 'required|string|max:255',
            'description' => 'nullable|string',
            'tags' => 'nullable|json',
            'typeable_type' => 'nullable|string|max:255',
            'typeable_id' => 'nullable|numeric',
        ]);

        $type = Type::find($id);
        
        $type->name = $request->name;
        $type->description = $request->description;
        $type->tags = $request->tags;
        $type->typeable_type = $request->typeable_type;
        $type->typeable_id = $request->typeable_id;
        $type->save();
        
        $success['title'] = 'ذخیره اطلاعات';
        $success['message'] = 'ذخیره اطلاعات موفقیت آمیز بود.';
        $success['type'] = $type;
        
        return $this->sendResponse($success, 'با موفقیت اضافه گردید.');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
