<?php

namespace App\Http\Controllers\API\v1;

use App\Http\Controllers\API\BaseController;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Role;
use App\Models\Permission;
use App\Models\Route;
use App\Models\State;
use App\Models\City;

class UserController extends BaseController
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
        $success['users'] = User::with('permissions', 'roles', 'verificode')->latest()->get();
        $success['roles'] = $roles = Role::with('permissions', 'users', 'routes')->latest('id')->get();
        $success['permissions'] = $permissions = Permission::with('roles', 'users', 'routes')->latest('id')->get();
        $success['routes'] = $routes = Route::orderBy('updated_at', 'desc')->latest('id')->get();

        return $this->sendResponse($success, 'اطلاعات دریافت شد');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
        $request->validate([
            'name' => 'required|string|max:255',
            'id' => 'required|numeric|exists:users,id',
        ]);
        
        $id = $request->input('id');
        $name = $request->input('name');
        $permissions = $request->input('permissions[]') ?? $request->input('permissions');
        $roles = $request->input('roles[]') ?? $request->input('roles');

        // return $permissions;

        $user = User::find($id);
        $userName = User::where('id', '!=', $id)->where('name', $name)->first();
        
        if(!$user){
            $user = new User();
        }
        $user->name = $name;
        $user->save();
        
        $permissionsId = $permissions;
        if (!empty($permissions) && (is_array($permissions[0]) || is_object($permissions[0]))) {
            $permissionsId = array_column($permissions, 'id');
        }
        $rolesId = $roles;
        if (!empty($roles) && (is_array($roles[0]) || is_object($roles[0]))) {
            $rolesId = array_column($roles, 'id');
        }

        $user->permissions()->sync($permissions ? $permissionsId : []);
        $user->roles()->sync($roles ? $rolesId : []);

        $success['title'] = 'ذخیره اطلاعات';
        $success['message'] = 'ذخیره اطلاعات موفقیت آمیز بود.';
        $success['status'] = 'success';
        $success['users'] = User::with('permissions', 'roles', 'verificode')->latest()->get();
        
        return $this->sendResponse($success, 'اطلاعات ذخیره شد.');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }

    public function getStatesCities() {
        
        $state_id = request()->state_id ?? null;
        $success['title'] = 'نمایش اطلاعات';
        $success['message'] = 'نمایش اطلاعات موفقیت آمیز بود.';
        $success['status'] = 'success';
        $success['states'] = State::where('country_id', 103)->orderBy('name')->get();
        $success['cities'] = null;
        if (is_numeric($state_id) && $state_id > 0) {
            $success['cities'] = City::where('state_id', $state_id)->orderBy('name_fa')->get();
        }
                
        return $this->sendResponse($success, 'اطلاعات .');
    }
}
