<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class AppendPhonePrefix
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        if ($request->phone && $request->has('phone') && !str_starts_with($request->phone, '0098')) {
            $request->merge(['phone' => '0098' . ltrim($request->phone, '0')]); // حذف صفر اضافی ابتدای شماره
        }

        return $next($request);
    }
}
