<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use App\Traits\JalaliTimestamps;
use Illuminate\Database\Eloquent\Model;

class DefaultMessage extends Model
{
    //
    use HasFactory, JalaliTimestamps;
    protected $guarded = [];
    
    protected $casts = [
        'variables' => 'array',
    ];
    
    protected $appends = ['VariablesString', 'BodyString'];

    public function getVariablesStringAttribute()
    {
        return json_encode($this->variables, JSON_UNESCAPED_UNICODE);
    }

    public function getBodyStringAttribute()
    {
        return json_encode($this->body, JSON_UNESCAPED_UNICODE);
    }
}
