<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use App\Traits\JalaliTimestamps;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class Patient extends Model
{
    //
    use HasFactory, JalaliTimestamps;
    protected $guarded = [];
    
    protected $appends = ['phone_international', 'DetailsContact', 'DetailsUser'];

    protected static function booted()
    {
        static::creating(function ($model) {
            if (empty($model->uuid)) {
                $model->uuid = self::getNextAvailableUuid();
                $model->uuid_string = self::getNextAvailableUuid();
            }
        });
    }
    
    protected static function getNextAvailableUuid()
    {
        // پیدا کردن کوچکترین عدد موجود در شکاف‌ها
        $gap = DB::selectOne("
            SELECT MIN(t1.uuid + 1) AS next_available
            FROM patients AS t1
            WHERE NOT EXISTS (
                SELECT 1 
                FROM patients AS t2 
                WHERE t2.uuid = t1.uuid + 1
            )
            AND t1.uuid < (SELECT MAX(uuid) FROM patients)
        ");
        
        // اگر شکافی پیدا شد، از آن استفاده کن
        if ($gap && $gap->next_available) {
            return $gap->next_available;
        }
        
        // در غیر این صورت، از آخرین عدد + 1 استفاده کن
        $max = DB::table('patients')->max('uuid');
        return $max ? $max + 1 : 1;
    }

    
    public function getDetailsContactAttribute()
    {
        return "محل کار: $this->work_phone" . PHP_EOL . "منزل: $this->home_phone" . PHP_EOL . "آدرس: $this->address";
    }

    public function getDetailsUserAttribute()
    {
        $phone = $this->user->phone;
        $name = $this->user->name;
        return "تلفن: $phone" . PHP_EOL . "نام یوزر: $name";
    }
    // public static function boot()
    // {
    //     parent::boot();

    //     static::creating(function ($patient) {
    //         $minUuid = DB::table('patients')->min('uuid');
    //         if ($minUuid === null) {
    //             $patient->uuid = 1;
    //         } else {
    //             $nextUuid = DB::table('patients')->where('uuid', '>=', $minUuid)->orderBy('uuid')->pluck('uuid')->toArray();
    //             $newUuid = 1;
    //             foreach ($nextUuid as $index => $value) {
    //                 if ($value != $index + 1) {
    //                     $newUuid = $index + 1;
    //                     break;
    //                 }
    //             }
    //             $patient->uuid = $newUuid;
    //         }
    //     });
    // }
    public function getPhoneInternationalAttribute()
    {
        // اگر شماره با 00 شروع شود، آن را به + تبدیل کنید
        if (substr($this->phone, 0, 2) === '00') {
            return '+' . substr($this->phone, 2);
        }
        // اگر شماره با + شروع شود، همان را بازگردانید
        if (substr($this->phone, 0, 1) === '+') {
            return $this->phone;
        }
        // اگر شماره با 0 شروع شود (فرضاً برای شماره‌های داخلی)، آن را به +98 تبدیل کنید
        if (substr($this->phone, 0, 1) === '0') {
            return '+98' . substr($this->phone, 1);
        }
        // در غیر این صورت، شماره را بدون تغییر بازگردانید
        return $this->phone;
    }

    
    public function user()
    {
        return $this->belongsTo(User::class);
    }
    
    public function country()
    {
        return $this->belongsTo(Country::class);
    }
    
    public function state()
    {
        return $this->belongsTo(State::class);
    }
    
    public function city()
    {
        return $this->belongsTo(City::class);
    }

    
    public function treatments()
    {
        return $this->hasMany(Treatment::class)->with(['user', 'patient', 'types', 'time_slot'])->latest();
    }
    
    public function time_slots()
    {
        return $this->hasMany(TimeSlot::class)->with('type')->latest();
    }

    
    public function answers()
    {
        return $this->hasMany(AnswerQuestion::class)->with(['type'])->latest();
    }
    
}
