<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use App\Traits\JalaliTimestamps;
use Illuminate\Database\Eloquent\Model;

class Permission extends Model
{
    use HasFactory, JalaliTimestamps;
    //
    protected $fillable = ['name'];

    
    public function roles()
    {
        return $this->belongsToMany(Role::class, 'permission_role');
    }

    public function routes()
    {
        return $this->belongsToMany(Route::class, 'permission_route');
    }

    public function users()
    {
        return $this->belongsToMany(User::class, 'permission_user');
    }
}
