<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use App\Traits\JalaliTimestamps;
use Illuminate\Database\Eloquent\Model;

class Role extends Model
{
    use HasFactory, JalaliTimestamps;
    //
    protected $fillable = ['name'];

    public function permissions()
    {
        return $this->belongsToMany(Permission::class, 'permission_role');
    }

    public function routes()
    {
        return $this->belongsToMany(Route::class, 'role_route');
    }

    public function users()
    {
        return $this->belongsToMany(User::class, 'role_user');
    }
}
