<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use App\Traits\JalaliTimestamps;
use Illuminate\Database\Eloquent\Model;

class Route extends Model
{
    use HasFactory, JalaliTimestamps;
    //
    protected $guarded = [];

    public function roles()
    {
        return $this->belongsToMany(Role::class, 'role_route');
    }

    public function permissions()
    {
        return $this->belongsToMany(Permission::class, 'permission_route');
    }

    public function children()
    {
        return $this->hasMany($this, 'parent_id', 'id');
    }
}
