<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use App\Traits\JalaliTimestamps;
use Illuminate\Database\Eloquent\Model;


class TimeSlot extends Model
{
    //
    use HasFactory, JalaliTimestamps;
    protected $guarded = [];
    // در مدل TimeSlot
    protected $casts = [
        'date_at' => 'date',
        'is_active' => 'boolean',
        // 'start_time' => 'datetime:H:i',
        // 'end_time' => 'datetime:H:i',
    ];

    public function allowedRelations(): array
    {
        return ['type']; // در سرویس ModelStatsService مدل رو به همراه روابط داخلی باید بگیریم روابطی که نیاز داریم رو اینجا اضافه میکنیم
    }

    // اسکوپ‌های مفید
    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }

    public function scopeFuture($query)
    {
        return $query->where('date_at', '>=', now()->format('Y-m-d'));
    }

    public function scopeAvailable($query)
    {
        return $query->active()->future()->whereNull('user_id');
    }

        
    public function type()
    {
        return $this->belongsTo(Type::class);
    }
    public function user()
    {
        return $this->belongsTo(User::class);
    }
    public function patient()
    {
        return $this->belongsTo(Patient::class);
    }
}
