<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use App\Traits\JalaliTimestamps;
use Illuminate\Database\Eloquent\Model;

class Treatment extends Model
{
    //
    use HasFactory, JalaliTimestamps;
    protected $guarded = [];
    protected $appends = ['typesString', 'TimeSlotString'];

    // public function types()
    // {
    //     return $this->belongsToMany(Type::class);//, 'treatment_type', 'type_id', 'treatment_id'
    // }
    public function types()
    {
        return $this->belongsToMany(Type::class, 'treatment_type', 'treatment_id', 'type_id');
    }
    public function getTypesStringAttribute()
    {
        return $this->types->pluck('name')->implode(' . ');
    }

    
    public function getTimeSlotStringAttribute()
    {
        $day_name = $this->time_slot->day_name ;
        $date_at_fa = $this->time_slot->date_at_fa ;
        $start_time = $this->time_slot->start_time ;
        return "روز: $day_name" . PHP_EOL . "$date_at_fa" . PHP_EOL . "ساعت: $start_time";
    }


    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function patient()
    {
        return $this->belongsTo(Patient::class);
    }
    public function time_slot()
    {
        return $this->belongsTo(TimeSlot::class);
    }
    
}
