<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use App\Traits\JalaliTimestamps;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;


class User extends Authenticatable
{
    /** @use HasFactory<\Database\Factories\UserFactory> */
    // use HasFactory, Notifiable;
    use HasFactory, Notifiable, HasApiTokens, JalaliTimestamps;

    /**
     * The attributes that are mass assignable.
     *
     * @var list<string>
     */
    protected $fillable = [
        'name',
        'phone',
        'email',
        'code_confirm',
        'account_verified_at',
        'phone_verified_at',
        'email_verified_at',
        'password',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var list<string>
     */
    protected $hidden = [
        'code_confirm',
        'password',
        'remember_token',
    ];

    protected $appends = ['phone_international'];

    /**
     * Get the attributes that should be cast.
     *
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'email_verified_at' => 'datetime',
            'password' => 'hashed',
        ];
    }

    /**
     * Get all of the VerificationCode for the User
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function verificodes()
    {
        return $this->hasMany(VerificationCode::class);
    }

    public function verificode()
    {
        return $this->hasOne(VerificationCode::class)->actived();//->where('code', $this->code_confirm);
    }

    public function getPhoneInternationalAttribute()
    {
        // اگر شماره با 00 شروع شود، آن را به + تبدیل کنید
        if (substr($this->phone, 0, 2) === '00') {
            return '+' . substr($this->phone, 2);
        }
        // اگر شماره با + شروع شود، همان را بازگردانید
        if (substr($this->phone, 0, 1) === '+') {
            return $this->phone;
        }
        // اگر شماره با 0 شروع شود (فرضاً برای شماره‌های داخلی)، آن را به +98 تبدیل کنید
        if (substr($this->phone, 0, 1) === '0') {
            return '+98' . substr($this->phone, 1);
        }
        // در غیر این صورت، شماره را بدون تغییر بازگردانید
        return $this->phone;
    }

    public function roles()
    {
        return $this->belongsToMany(Role::class, 'role_user');
    }

    public function permissions()
    {
        return $this->belongsToMany(Permission::class, 'permission_user');
    }

    public function accessibleRoutes()
    {
        $roleIds = $this->roles->pluck('id');
        $permissionIds = $this->permissions->pluck('id');

        return Route::whereHas('roles', function ($query) use ($roleIds) {
            $query->whereIn('id', $roleIds);
        })
        ->orWhereHas('permissions', function ($query) use ($permissionIds) {
            $query->whereIn('id', $permissionIds);
        })
        ->with('children')
        ->orderBy('orderby')
        ->get();
    }

    public function messages()
    {
        return $this->hasMany(Message::class);
    }
    // public function notifications()
    // {
    //     return $this->hasMany(Notification::class);
    // }

    public function patients()
    {
        return $this->hasMany(Patient::class)->with([
            'user',
            'country',
            'state',
            'city',
            'treatments',
            'time_slots',
            'answers'
        ]);
    }
        
    public function country()
    {
        return $this->belongsTo(Country::class);
    }
    
    public function state()
    {
        return $this->belongsTo(State::class);
    }
    
    public function city()
    {
        return $this->belongsTo(City::class);
    }
        
    public function treatments()
    {
        return $this->hasMany(Treatment::class)->with(['patient', 'user', 'types', 'time_slot'])->latest();
    }
    
    public function time_slots()
    {
        return $this->hasMany(TimeSlot::class)->with('type','user')->latest();
    }
}
