<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use App\Traits\JalaliTimestamps;
use Illuminate\Database\Eloquent\Model;
use Carbon\Carbon;

class VerificationCode extends Model
{
    use HasFactory, JalaliTimestamps;

    protected $fillable = ['user_id', 'code', 'type', 'expires_at'];

    public function isExpired()
    {
        return Carbon::now()->greaterThan($this->expires_at);
    }

    public function scopeActived($query)
    {
        return $query->where('expires_at', '>', Carbon::now());
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
