<?php

namespace App\Services;

use App\Models\Message;
use Illuminate\Support\Facades\Log;

class MessageService
{
    public static function send(Message $message, $customVariables = [])
    {
        $parsedBody = self::parseBody($message->body, $customVariables);
    
        Log::info("ارسال پیام: $parsedBody");
    
        $message->status = 'sent';
        $message->save();
    }

    public static function parseBody($body, $customVariables = [])
    {
        foreach ($customVariables as $key => $value) {
            $body = str_replace("{" . $key . "}", $value, $body);
        }

        return $body;
    }
}

/*
 POST /api/default-messages
 {
   "title": "تخفیف ویژه",
   "body": "سلام {name}، {product} با تخفیف {discount}% برای شما فعال شده!",
   "variables": ["product", "discount"]
 }
********************************************************************
 POST /api/messages
 {
   "user_id": 1,
   "body": "سلام {name}، {product} با تخفیف {discount}% برای شما فعال شده!",
   "variables": {
     "product": "کفش نایک",
     "discount": "30"
   },
   "scheduled_at": null
 }

********************************************************************
 POST /api/messages
 {
   "user_id": 1,
   "body": "سلام {name}، تخفیف {discount}% روی {product} برای شما فعال شده.",
   "variables": {
     "name": "علی",
     "discount": "30",
     "product": "کفش نایک"
   },
   "scheduled_at": null
 }

********************************************************************
 POST /api/messages/preview
 {
   "body": "سلام {name}، تخفیف {discount}% روی {product} فعال شد!",
   "variables": {
     "name": "علی",
     "discount": "20",
     "product": "کتانی آدیداس"
   }
 }

 {
  "preview": "سلام علی، تخفیف 20% روی کتانی آدیداس فعال شد!"
}
 */