<?php

namespace App\Services;

use App\Models\User;
use App\Notifications\SimpleNotification;
use Illuminate\Support\Collection;

class NotificationService
{
    /**
     * ارسال نوتیفیکیشن به یک یا چند کاربر
     *
     * @param int|array|Collection $userIds
     * @param string $title
     * @param string $body
     */
    public function sendToUsers($userIds, string $title, string $body): void
    {
        $users = User::whereIn('id', collect($userIds)->toArray())->get();

        foreach ($users as $user) {
            $user->notify(new SimpleNotification($title, $body));
        }
    }

    /**
     * ارسال به یک کاربر خاص
     */
    public function sendToUser(int $userId, string $title, string $body): void
    {
        $this->sendToUsers([$userId], $title, $body);
    }
}


/*
    use App\Services\NotificationService;

    class OrderController extends Controller
    {
        public function notifyUsers(NotificationService $notificationService)
        {
            $notificationService->sendToUsers([1, 2, 3], 'سفارش جدید!', 'سفارش جدیدی ثبت شد!');
        }
    }
 */