<?php

namespace App\Traits;

use Morilog\Jalali\Jalalian;
use Carbon\Carbon;

trait JalaliTimestamps
{
    /**
     * متد جادویی برای دسترسی به اتریبیوت‌های پویا
     */
    public function __get($key)
    {
        if (str_ends_with($key, '_fa')) {
            $originalKey = str_replace('_fa', '', $key);
            if (array_key_exists($originalKey, $this->attributes) && $this->isDateAttribute($originalKey)) {
                return $this->getJalaliDate($originalKey);
            }
        }
        return parent::__get($key);
    }

    /**
     * تبدیل تاریخ میلادی به شمسی
     */
    protected function getJalaliDate($column)
    {
        if (is_null($this->$column)) {
            return null;
        }

        // اگر مقدار ستون به صورت Carbon نیست، آن را به Carbon تبدیل کن
        $date = $this->$column instanceof Carbon ? $this->$column : Carbon::parse($this->$column);
        $jalali = Jalalian::fromCarbon($date);
        return $jalali->format('H:i') === '00:00' 
            ? $jalali->format('d F Y')
            : $jalali->format('d F Y') . PHP_EOL . $jalali->format('H:i');
        return Jalalian::fromCarbon($date)->format('d,F Y') . PHP_EOL . Jalalian::fromCarbon($date)->format('H:i');
    }

    /**
     * بررسی اینکه آیا یک ستون از نوع تاریخ است
     */
    protected function isDateAttribute($key)
    {
        return str_ends_with($key, '_at');
    }

    /**
     * اضافه کردن اتریبیوت‌های شمسی به خروجی JSON
     */
    public function toArray()
    {
        $array = parent::toArray();

        foreach ($this->attributes as $key => $value) {
            if ($this->isDateAttribute($key)) {
                $array[$key . '_fa'] = $this->getJalaliDate($key);
            }
        }

        return $array;
    }
}