<?php

use App\Http\Middleware\AppendPhonePrefix;
use App\Http\Middleware\SetJsonAcceptHeader;
use Illuminate\Foundation\Application;
use Illuminate\Foundation\Configuration\Exceptions;
use Illuminate\Foundation\Configuration\Middleware;

return Application::configure(basePath: dirname(__DIR__))
    ->withRouting(
        web: __DIR__ . '/../routes/web.php',
        api: __DIR__ . '/../routes/api.php',
        commands: __DIR__ . '/../routes/console.php',
        health: '/up',
    )
    ->withMiddleware(function (Middleware $middleware) {
        //
        $middleware->use([
            //
            \Illuminate\Http\Middleware\HandleCors::class,
            AppendPhonePrefix::class,
        ]);

        $middleware->web(append: [
            //
        ]);

        $middleware->api(prepend: [
            SetJsonAcceptHeader::class,
            // \Illuminate\Http\Middleware\HandleCors::class,
        ]);
    })
    ->withExceptions(function (Exceptions $exceptions) {
        //
    })->create();
