<?php
namespace Database\Factories;

use App\Models\Patient;
use Faker\Generator as Faker;
use Illuminate\Database\Eloquent\Factories\Factory;

class PatientFactory extends Factory
{
    protected $model = Patient::class;

    public function definition()
    {
        return [
            'user_id' => \App\Models\User::factory(),
            'uuid' => $this->faker->unique()->numberBetween(1000000000, 9999999999),
            'uuid_string' => $this->faker->uuid(),
            'fullname' => $this->faker->name(),
            'sex' => $this->faker->randomElement(['male', 'female', 'other']),
            'marital_status' => $this->faker->randomElement(['single', 'married', 'divorced', 'widowed']),
            'home_phone' => $this->faker->phoneNumber(),
            'work_phone' => $this->faker->phoneNumber(),
            'birth_day_at' => $this->faker->dateTimeThisCentury(),
            'father_name' => $this->faker->name(),
            'mother_name' => $this->faker->name(),
            'job_mother_or_father' => $this->faker->word(),
            'reagent' => $this->faker->word(),
            'country_id' => 1,
            'state_id' => 1,
            'city_id' => 1,
            'address' => $this->faker->address(),
            'confirmed_at' => $this->faker->optional()->dateTime(),
            'created_at' => $this->faker->dateTimeBetween('-1 year', 'now'), // تاریخ تصادفی بین یک سال پیش و الان
        ];
    }
}
