<?php

// database/factories/TimeSlotFactory.php

namespace Database\Factories;

use App\Models\TimeSlot;
use Faker\Generator as Faker;
use Illuminate\Database\Eloquent\Factories\Factory;

class TimeSlotFactory extends Factory
{
    protected $model = TimeSlot::class;

    public function definition()
    {
        return [
            'date_at' => $this->faker->date(),
            'day_name' => $this->faker->dayOfWeek,
            'start_time' => $this->faker->time(),
            'end_time' => $this->faker->time(),
            'is_active' => $this->faker->boolean(),
            'user_id' => \App\Models\User::factory(),
            'patient_id' => \App\Models\Patient::factory(),
            'type_id' => 1,
            'reservation_name' => $this->faker->name(),
            'reservation_phone' => $this->faker->phoneNumber(),
            'notes' => $this->faker->optional()->text(),
            'show_user' => $this->faker->boolean(),
            'created_at' => $this->faker->dateTimeBetween('-1 year', 'now'), // تاریخ تصادفی بین یک سال پیش و الان
        ];
    }
}
