<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Type>
 */
class TypeFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'name' => $this->faker->word(),
            'description' => $this->faker->sentence(),
            'tags' => json_encode($this->faker->randomElements(['GET', 'POST', 'PUT', 'DELETE'], rand(1, 3))),
            'typeable_id' => rand(1, 10),
            'typeable_type' => $this->faker->randomElement(['App\Models\Post', 'App\Models\User']),
        ];
    }
}
