<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('routes', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->string('orderby')->default("0");
            $table->string('path')->unique();
            $table->string('route_name')->nullable();//->default(json_encode(['GET']));
            $table->json('methods')->nullable();//->default(json_encode(['GET']));
            $table->string('type')->nullable();
            $table->string('showin')->nullable(); // show in menu toolbar and ...
            $table->string('group')->nullable();
            $table->boolean('divider')->default(false);
            $table->unsignedBigInteger('parent_id')->nullable();
            $table->text('description')->nullable();
            $table->text('icon')->nullable();
            $table->json('attributes')->nullable();
            $table->timestamp('actived_at')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('routes');
    }
};
