<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('patients', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->bigInteger('uuid')->unique();
            $table->string('uuid_string')->nullable();
            $table->string('fullname')->nullable();
            $table->string('national_code')->nullable();
            $table->string('sex')->nullable(); // new ['mail', 'female'. 'other']
            $table->string('marital_status')->nullable(); // new ['single', 'married', 'divorced', 'widowed']
            $table->string('home_phone')->nullable(); // new 
            $table->string('work_phone')->nullable(); // new 
            $table->datetime('birth_day_at')->nullable();
            $table->string('father_name')->nullable();
            $table->string('mother_name')->nullable();
            $table->string('job_mother_or_father')->nullable();
            $table->string('reagent')->nullable();
            $table->foreignId('country_id')->nullable()->constrained()->onDelete('set null');
            $table->foreignId('state_id')->nullable()->constrained()->onDelete('set null');
            $table->foreignId('city_id')->nullable()->constrained()->onDelete('set null');
            $table->text('address')->nullable();
            $table->timestamp('confirmed_at')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('patients');
    }
};
