<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('time_slots', function (Blueprint $table) {
            $table->id();
            $table->date('date_at'); // تاریخ
            $table->string('day_name'); // نام روز (شنبه، یکشنبه، ...)
            $table->time('start_time'); // زمان شروع (مثلا 18:00:00)
            $table->time('end_time');   // زمان پایان (مثلا 18:05:00)
            $table->boolean('is_active')->default(true); // وضعیت فعال/غیرفعال
            $table->foreignId('user_id')->nullable()->constrained()->onDelete('set null'); // کاربر رزرو کننده
            $table->foreignId('patient_id')->nullable()->constrained()->onDelete('set null'); // کاربر رزرو کننده
            $table->foreignId('type_id')->nullable()->constrained()->onDelete('set null'); // نوع نوبت
            $table->string('reservation_name')->nullable(); // نام شخص رزروکننده
            $table->string('reservation_phone')->nullable(); // تلفن تماس
            $table->text('notes')->nullable(); // یادداشت‌های اضافی
            $table->boolean('show_user')->default(true);

            
            $table->timestamps();
            
            // ایندکس‌های پیشنهادی
            $table->index(['date_at', 'start_time']);
            $table->index(['is_active']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('time_slots');
    }
};
