<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('treatments', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->nullable()->constrained()->onDelete('set null');
            $table->foreignId('patient_id')->nullable()->constrained()->onDelete('set null');
            $table->foreignId('time_slot_id')->nullable()->constrained()->onDelete('set null'); //  نوبت
            $table->decimal('cost')->default(0);
            $table->string('payment_method')->nullable();
            $table->text('payment_description')->nullable();
            $table->text('description')->nullable();
            $table->timestamp('treatment_at')->nullable();
            $table->timestamps();
        });
        Schema::create('treatment_type', function (Blueprint $table) {
            $table->foreignId('treatment_id')->constrained()->onDelete('cascade');
            $table->foreignId('type_id')->constrained()->onDelete('cascade');
            $table->primary(['treatment_id', 'type_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('treatments');
        Schema::dropIfExists('treatment_type');
    }
};
