<?php

namespace Database\Seeders;

use App\Models\Permission;
use App\Models\Role;
use App\Models\Route;
use App\Models\User;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use Faker\Factory as Faker;

class DefaultSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        //

        $user = User::factory()->create([
            'password' => bcrypt('1430548'),
            'email' => 'admin@admin.com',
            'phone' => '00989135368845',
            'name' => 'admin',
        ]);
        
        // ایجاد مسیرها
        // $route1 = Route::create(['title' => 'داشبورد', 'path' => '/dashboard', 'methods' => json_encode(['GET']), 'description' => 'صفحه داشبورد']);
        // $route2 = Route::create(['title' => 'کاربر', 'path' => '/routes', 'methods' => json_encode(['GET']), 'description' => 'روتها']);

        // // ایجاد رول‌ها
        $adminRole = Role::create(['name' => 'admin']);
        $drRole = Role::create(['name' => 'دکتر']);
        $managerRole = Role::create(['name' => 'مدیر مالی']);
        $employeeRole = Role::create(['name' => 'کارمندان']);
        $userRole = Role::create(['name' => 'کاربران']);

        // // ایجاد پرمیشن‌ها
        // $viewDashboard = Permission::create(['name' => 'view-dashboard']);
        // $viewRoutes = Permission::create(['name' => 'view-routes']);

        // // ارتباط رول‌ها و مسیرها
        // $adminRole->routes()->attach([$route1->id, $route2->id]);
        // $drRole->routes()->attach($route1->id);
        // $managerRole->routes()->attach($route1->id);
        // $employeeRole->routes()->attach($route1->id);
        // $userRole->routes()->attach($route1->id);

        // // ارتباط پرمیشن‌ها و مسیرها
        // $viewDashboard->routes()->attach($route1->id);
        // $viewRoutes->routes()->attach($route2->id);

        $user->roles()->attach([ $adminRole->id, $drRole->id, $managerRole->id, $employeeRole->id, $userRole->id ]);
        // $user->permissions()->attach([$viewDashboard->id, $viewRoutes->id]);
    }
}
