<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;

class ImportTableDataSeeder extends Seeder
{
    public function run()
    {
        // مسیر جدید فایل JSON
        $filePath = base_path('database/backup/tablesExport(routes-permissions).json');

        // بررسی وجود فایل
        if (!File::exists($filePath)) {
            $this->command->error("File not found: " . $filePath);
            return;
        }

        // خواندن داده از فایل JSON
        $json = File::get($filePath);
        $data = json_decode($json, true);

        // بررسی صحت داده‌های خوانده شده
        if (!$data) {
            $this->command->error('Invalid JSON data or empty file.');
            return;
        }

        // بررسی و وارد کردن داده‌ها برای هر جدول
        foreach ($data as $tableName => $tableData) {
            // اگر داده‌هایی برای جدول وجود داشته باشد
            if (is_array($tableData)) {
                // بازنشانی جدول قبل از وارد کردن داده‌ها
                DB::table($tableName)->truncate();

                // درج داده‌ها در جدول
                if (!empty($tableData)) {
                    DB::table($tableName)->insert($tableData);
                    $this->command->info("\tData inserted successfully into {$tableName}.");
                } else {
                    $this->command->info("\tNo data to insert into {$tableName}.");
                }
            }
        }
    }
}
