<?php

use App\Http\Controllers\API\AuthController;
use App\Http\Controllers\API\v1\RouteController;
use App\Http\Controllers\API\v1\RolePermissionController;
use App\Http\Controllers\API\v1\UserController;
use App\Http\Controllers\API\v1\TypeController;
use App\Http\Controllers\API\v1\PatientsController;
use App\Http\Controllers\API\v1\TimeSlotController;
use App\Http\Controllers\API\v1\TreatmentController;
use App\Http\Controllers\API\v1\MessageController;
use App\Http\Controllers\API\v1\DefaultMessageController;
use App\Http\Controllers\API\v1\ExcelController;
use App\Http\Controllers\API\v1\NotificationController;
use App\Http\Controllers\API\v1\DashboardController;
use App\Http\Controllers\API\CronJob\CronJobController;
use App\Http\Middleware\CheckRouteAccess;
use App\Http\Middleware\SetJsonAcceptHeader;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

Route::prefix('v1')->group(function () {

    Route::get('/test', function (Request $request) {
        $user = \App\Models\User::find(1);
        return ($user && $user->roles && $user->roles->contains('name', 'admin'));
        // return $request->all();
    });

    Route::controller(AuthController::class)->group(function () {
        Route::post('register', 'register')->name('register');
        Route::post('login', 'login')->name('login-password');
        Route::post('send-verification-code', 'sendVerificationCode')->name('send-verification-code');
        Route::post('verify-code', 'verifyCode')->name('confirm-code-phone');
    });
    
    Route::get('states-cities', [UserController::class, 'getStatesCities'])->name('show.states.cities');

    // Route::get('/user', function (Request $request) {
    //     return $request->user();
    // })->middleware('auth:sanctum');

    Route::middleware('auth:sanctum')->group(function () {

        Route::controller(AuthController::class)->group(function () {
            Route::post('reset-password', 'resetPassword')->name('reset-password-api');
            Route::post('get-user', 'getUser')->name('get-user');
            Route::get('get-user', 'getUser')->name('get-user');
            Route::put('update-user', 'updateUser')->name('update-user');
        });

        Route::get('/get-patient/{id}', [PatientsController::class, 'getPatient'])->name('patient.full.data');
        
        // Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard.index');
        Route::get('/chart', [DashboardController::class, 'getChartData'])->name('dashboard.chart');

        Route::middleware('auth:sanctum')->prefix('notifications')->group(function () {
            Route::get('/', [NotificationController::class, 'index']); // همه نوتیفیکشن‌ها
            Route::get('/unread', [NotificationController::class, 'unread']); // فقط خوانده‌نشده‌ها
            Route::post('/', [NotificationController::class, 'store']); // ساخت نوتیفیکیشن جدید
            Route::post('/{id}/read', [NotificationController::class, 'markAsRead']); // تکی خوانده شده
            Route::post('/mark-all-read', [NotificationController::class, 'markAllAsRead']); // همه خوانده شده
            Route::delete('/{id}', [NotificationController::class, 'destroy']); // حذف نوتیفیکیشن
        });
    });


    Route::get('update-routes', [RouteController::class, 'updateRoutes'])->name('update.routes');
    Route::post('update-routes-front', [RouteController::class, 'updateRoutesFront'])->name('update.routes.front');
    Route::middleware([CheckRouteAccess::class])->group(function () { //, 'auth:sanctum'

        Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard.index');
        Route::post('/upload-excel', [ExcelController::class, 'uploadExcel'])->name('upload.excel');
        //
        Route::apiResource('routes', RouteController::class);

        Route::apiResource('users', UserController::class);
        Route::apiResource('types', TypeController::class);

        Route::get('roles-permissions', [RolePermissionController::class, 'index'])->name('get.roles.and.permissions');
        Route::post('create-or-update-permission', [RolePermissionController::class, 'createUpdatePermission'])->name('create.or.update.permission');
        Route::delete('delete-permission/{id}', [RolePermissionController::class, 'deletePermission'])->name('delete.permission');
        Route::post('create-or-update-role', [RolePermissionController::class, 'createUpdateRole'])->name('create.or.update.role');
        Route::get('show-role/{id}', [RolePermissionController::class, 'showRole'])->name('show.role');

        Route::apiResource('patients', PatientsController::class);
        Route::post('answer-questions-patient', [PatientsController::class, 'answerQuestions'])->name('answer.questions.patient');

        
        Route::apiResource('treatments', TreatmentController::class);

        // پیام‌های پیش‌فرض
        Route::prefix('default-messages')->group(function () {
            Route::get('/', [DefaultMessageController::class, 'index'])->name('messages.default.show');         // لیست پیام‌ها
            Route::post('/', [DefaultMessageController::class, 'store'])->name('message.default.store');        // ساخت پیام جدید
            Route::put('/{id}', [DefaultMessageController::class, 'update'])->name('message.default.update');    // ویرایش پیام
            Route::delete('/{id}', [DefaultMessageController::class, 'destroy'])->name('message.default.remove'); // حذف پیام
        });

        // پیام‌های ارسالی به کاربران
        Route::prefix('messages')->group(function () {
            Route::get('/', [MessageController::class, 'index'])->name('messages.show');               // لیست پیام‌های ارسالی
            Route::post('/', [MessageController::class, 'sendMessage'])->name('message.send');              // ارسال پیام (با یا بدون زمان‌بندی)
            Route::post('/preview', [MessageController::class, 'previewMessage'])->name('message.preview');
            Route::delete('/{id}', [MessageController::class, 'destroy'])->name('message.remove');      // حذف پیام
        });
    });

    Route::get('/time-slots/weekly2', [TimeSlotController::class, 'timeSlotes'])->name('time.slots.weekly.2');
    Route::get('/time-slots', [TimeSlotController::class, 'index'])->name('time.slots');
    Route::post('/reserve-slot', [TimeSlotController::class, 'reserveSlot']);
    


    // http://localhost/dr/backend/public/api/v1/cronjob/generate-time-slots
    Route::prefix('cronjob')->group(function () {
        //0 8 * * 4 curl -s "https://yourdomain.com/cron/generate-time-slots?token=5464210sdcsdvdfvbdfbfgbfgbfgbgh3214435546566732465464" > /dev/null
        Route::get('/generate-time-slots', [TimeSlotController::class, 'generate']);//->middleware('auth.basic'); // محافظت با Basic Auth
        Route::get('/users-visit-today', [CronJobController::class, 'usersVisitToday']);//->middleware('auth.basic'); // محافظت با Basic Auth
    });
});


